<?php
// Database connection is already established in the calling file

function formatCurrency($amount) {
    global $pdo;
    
    try {
        // Get currency from settings
        $stmt = $pdo->query("SELECT setting_value FROM store_settings WHERE setting_key = 'store_currency'");
        $currency = $stmt->fetchColumn() ?: 'Ksh'; // Default to Ksh if not found
        
        // Format the amount with 2 decimal places
        $formattedAmount = number_format($amount, 2);
        
        // Return formatted currency string
        return $currency . ' ' . $formattedAmount;
    } catch (PDOException $e) {
        error_log("Error getting currency setting: " . $e->getMessage());
        return 'Ksh ' . number_format($amount, 2); // Fallback to Ksh
    }
}

function getCurrencySymbol() {
    global $pdo;
    
    try {
        $stmt = $pdo->query("SELECT setting_value FROM store_settings WHERE setting_key = 'store_currency'");
        return $stmt->fetchColumn() ?: 'Ksh'; // Default to Ksh if not found
    } catch (PDOException $e) {
        error_log("Error getting currency symbol: " . $e->getMessage());
        return 'Ksh'; // Fallback to Ksh
    }
}
?> 